#include <iostream>
#include <unordered_map>

struct AxisCount { int even = 0; int odd = 0; };

int main() {
    int count;
    std::cin >> count;
    std::unordered_map<long, int> hashmap1;
    std::unordered_map<long, int> hashmap2;
    std::unordered_map<long, AxisCount> hashmapX;
    std::unordered_map<long, AxisCount> hashmapY;

    for (int i = 0; i < count; i++) {
        int x, y;
        std::cin >> x >> y;
        hashmap1[x - y]++;
        hashmap2[x + y]++;
        if (y % 2) hashmapX[x].odd++;
        else hashmapX[x].even++;
        if (x % 2) hashmapY[y].odd++;
        else hashmapY[y].even++;
    }

    int greetings = 0;
    for (const auto [key, val] : hashmap1)
        greetings += val * (val - 1);
    for (const auto [key, val] : hashmap2)
        greetings += val * (val - 1);
    for (const auto [key, val] : hashmapX)
        greetings += (val.odd * (val.odd - 1) + val.even * (val.even - 1)) / 2;
    for (const auto [key, val] : hashmapY)
        greetings += (val.odd * (val.odd - 1) + val.even * (val.even - 1)) / 2;

    std::cout << greetings;
}